/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	VillagerSkills
**
** DESCRIPTION:	Villager skills
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef VILLAGER_SKILLS_H
#define VILLAGER_SKILLS_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "SkillTypes.h"
#include "ldwGameState.h"
#include "../Game/Potion.h"

class CVillager;

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int VillagerSkills_c_iTraineeLevel = 20;
const int VillagerSkills_c_iAdeptLevel = 50;
const int VillagerSkills_c_iMasterLevel = 88;
const int VillagerSkills_c_iPredisposedLevel = 1;

/******************************************************************************\
** TYPE DEFINITIONS
\******************************************************************************/
struct SSkillData
{
};

struct SAlchemySkillData : SSkillData
{
	//structure data
	EPotion		m_ePotion;

	//structure methods
	//setup
	public:		SAlchemySkillData(const EPotion ePotion) { m_ePotion = ePotion; }
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CVillagerSkills
{
private:

	//class data
	int			m_iSkillLevel[eSkill_NumberOf];
	ESkill		m_ePreferredSkill;

	//class methods
	//setup
	public:		CVillagerSkills();
	public:		void Copy(CVillagerSkills &Skills);
	public:		void Reset();

	//process
	public:		void Update(CVillager &Villager);

	//access
	public:		void SetSkill(const ESkill eSkill, const int iLevel) { m_iSkillLevel[eSkill] = iLevel; if (m_iSkillLevel[eSkill] > 100) m_iSkillLevel[eSkill] = 100; else if (m_iSkillLevel[eSkill] < 0) m_iSkillLevel[eSkill] = 0; }
	public:		void AdjustSkill(const ESkill eSkill, const int iAdj) { m_iSkillLevel[eSkill] += iAdj; if (m_iSkillLevel[eSkill] > 100) m_iSkillLevel[eSkill] = 100; else if (m_iSkillLevel[eSkill] < 0) m_iSkillLevel[eSkill] = 0; }
	public:		const int Skill(const ESkill eSkill) const { return m_iSkillLevel[eSkill]; }

	public:		void SetPreferredSkill(const ESkill ePreferredSkill) { m_ePreferredSkill = ePreferredSkill; }
	public:		const ESkill PreferredSkill() const { return m_ePreferredSkill; }

	public:		const ESkill RandomSkill() const { return (ESkill)randN(eSkill_NumberOf); }
	public:		const ESkill BestSkill(int *piBestLevel = 0) const;
	public:		const int TotalSkill() const;
	public:		const int SkillsMastered() const;

	public:		const bool IsEsteemedElder() const;

	public:		const bool IsTraineeOf(ESkill eSkill) const { return m_iSkillLevel[eSkill] >= VillagerSkills_c_iTraineeLevel; }
	public:		const bool IsAdeptAt(ESkill eSkill) const { return m_iSkillLevel[eSkill] >= VillagerSkills_c_iAdeptLevel; }
	public:		const bool IsMasterOf(ESkill eSkill) const { return m_iSkillLevel[eSkill] >= VillagerSkills_c_iMasterLevel; }
	public:		const bool IsMasterOfAny() const;
	public:		const bool IsTraineeLevel(const int iLevel) const { return iLevel >= VillagerSkills_c_iTraineeLevel; }
	public:		const bool IsAdeptLevel(const int iLevel) const { return iLevel >= VillagerSkills_c_iAdeptLevel; }
	public:		const bool IsMasterLevel(const int iLevel) const { return iLevel >= VillagerSkills_c_iMasterLevel; }

	public:		const bool IsInexperiencedAt(const ESkill eSkill) const { return m_iSkillLevel[eSkill] == 0; }
	public:		const bool IsInclinedTo(const ESkill eSkill) const { return m_iSkillLevel[eSkill] >= VillagerSkills_c_iPredisposedLevel; }
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/